#ifndef _CSockSrvr_H
#define _CSockSrvr_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define IDEAL_RECV_SIZE      5120 // The ideal ammount of data that can be received at once.
#define IDEAL_SEND_SIZE      5120 // The ideal ammount of data the client send buffer can hold.
#define INITSENDRECVSZ       1024 // The initial size of the client Send and Receive buffers.

#define PACKETHEADER         12345

#define TCPHANDLER_MS_WAIT   1
#define CLIENTTHREAD_MS_WAIT 1

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to pass class data to the client thread
typedef struct _CLIENTTHREADINFO{
    int Client;
}CLIENTTHREADINFO, *LPCLIENTTHREADINFO;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class CSockSrvr{
public:
    bool DoConnect(char *sRemoteAddr, int iRemotePort, int *ioutClient);
    bool GetClientData(int iClient, char *outsBuf, int *outiSize);
    bool GetNextClientData(int iClient, char *outsBuf, int *outiSize);
    bool Initialize(int MaxClients);
    bool IsClientDataPending(int iClient);
    bool IsClientDataWaiting(int iClient);
    bool SetNextSendData(int iClient, char *sData);
    bool SetNextSendDataEx(int iClient, char *sData, int iSize);
    bool SetSendData(int iClient, char *sData);
    bool SetSendDataEx(int iClient, char *sData, int iSize);
    bool Start(int iListenPort);
    bool Stop(void);
    bool UnInitialize(void);
    bool WaitOnClientDataToBeRecvd(int iClient);
    bool WaitOnClientDataToBeSent(int iClient);
    int GetCurrentClients(void);
    int GetMaxClients(void);
    int GetNextClientID(void);
    int SendData(int iClient, char *sData);
    int SendDataEx(int iClient, char *sData, int iSize);
    void DropBadPacketData(int iClient, bool bDropBad);
    void SetNextClientID(int iClientID);
    void SetRawStreamMode(int iClient, bool bRawMode);

	CRITICAL_SECTION CriticalSection1;

	class SubClass_Events{
	public:
		void OnBeginClientThread(CSockSrvr *lpCSockSrvr, int iClient);
		void OnEndClientThread(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnAccept(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnConnect(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnAcceptConnect(CSockSrvr *lpCSockSrvr, int iClient);
		void OnDisconnect(CSockSrvr *lpCSockSrvr, int iClient);
		bool OnStart(CSockSrvr *lpCSockSrvr, int iListenPort);
		bool OnStop(CSockSrvr *lpCSockSrvr);
		bool OnSend(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize);
		bool OnRecv(CSockSrvr *lpCSockSrvr, int iClient, char *sData, int iSize);
	};
	SubClass_Events Events;

	//------------------------------------------------------------

private:
    bool DoConnectEx(char *sRemoteAddr, int iRemotePort, int *ioutClient);
    bool Close_ListenSocket(void);
    bool DisconnectClient(int iClient);
    bool DoAccept(void);
    bool DoRecv(int iClient);
    bool DoSend(int iClient);
    bool OnAcceptConnectClient(int iClient);
    void OnDisconnectClient(int iClient);
    bool Open_ListenSocket(int iListenPort);
	bool ResizeSendBuffer(int iClient, int iSize);
	bool ResizeRecvBuffer(int iClient, int iSize);
    bool Start_ClientThread(int iClient);
    bool Start_WindowsSocket(void);
    bool Stop_WindowsSocket(void);
    bool WaitOnClientThreadToExit(int iClient);
    int BreakClassPacket(int iClient, char *outBuf, int *iOutBufSz);
    int MakeClassPacket(char *outBuffer, const char *inBuffer, int inLength);
    int GetFreeSocketSlot(void); // Search for free client "Slot"

public:
    //------------------------------------------------------------------------
    //Client specific items (Begin)
    //------------------------------------------------------------------------
    bool *bcConnected;       // Remote client's connection flag
    bool *bcDisconnect;      // Remote client's disconnect flag
    bool *bcDropBadPackets;  // Drop bad client packets
    bool *bcRawDataMode;     // Is this client using Raw or Packet data mode (True=Raw, False=Packet)
	bool *bcWasConnect;      // True is the client was connected, false if the client was accepted.
	char **scRecvBuf;        // Clients receive buffer
    char **scSendBuf;        // Clients send buffer
    int *icClientID;         // Remote client's ID (For client identification)
	int *icMaxSendBufSz;     // The number of byte of memory allocated for scSendBuf.
	int *icMaxRecvBufSz;     // The number of byte of memory allocated for scRecvBuf.
	int *icRecvBufSz;        // The size of the content in the clients scRecvBuf
    int *icRecvOffset;       // Data offset (Used for packet data)
    int *icSendBufSz;        // The size of the content in the clients scSendBuf
    SOCKET *sckcSocket;      // Remote client's socket
	bool cbActive;           // Is the server started?

private:
    friend DWORD WINAPI Client_Thread_Function(LPVOID pvThread);

    DWORD *dwcClient_Thread_ID;
    HANDLE *hcClient_Thread_Handle;

    CLIENTTHREADINFO CTI;
    //------------------------------------------------------------------------
    //Client specific items (End)
    //------------------------------------------------------------------------

    int icCurrentClients; // The amount of clients connected to the server
    int icMaxClients;     // Max clients allowed to connect
    int icNextClientID;   // The next assigned Client ID

    SOCKET sckcListenSocket; // Listen socket of local server

    fd_set ExceptFDS; // FDS Except
    fd_set ReadFDS;   // FDS Read
    fd_set WriteFDS;  // FDS Write

    struct timeval TimeOut;  // TimeOut

    bool IsListeningServer;

    //------------------------------------------------------------------------
    //The TCPHandler routine threading items (Begin)
    //------------------------------------------------------------------------
    friend DWORD WINAPI TCPHandler_Thread_Function(LPVOID pvThread);

    bool Start_TCPHandler(void);
    bool Stop_TCPHandler(void);

    bool bcShutdownTCPHandler;
    bool bcTCPHandlerActive;

    DWORD dwcTCPHandler_Thread_ID;
    HANDLE hcTCPHandler_Thread_Handle;
    //------------------------------------------------------------------------
    //The TCPHandler routine threading items (End)
    //------------------------------------------------------------------------
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FatalError(char *sFile, int iLine, char *sErrorMsg);

//NON-STANDARD DEFINITIONS (BEGIN)

extern CSockSrvr gServer;

//NON-STANDARD DEFINITIONS (END)

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

